TimeStart("Plotting RIXS tensor")


RIXS_spinwaves_EuO = [[

directory = "data/"

set terminal postscript enhanced color
set out '_4_RIXS_spinwaves_EuO.ps'


set xlabel "Rotation angle {/Symbol q}[degree]"
set ylabel "Energy [meV]"
plot directory . 'RIXS_spinwaves_EuO.dat' using ($1/100*90):2 title "Single magnon dispersion" with lines

set ylabel "Intensity [a.U.]"
OppList = "OppR_{A1g} OppR_{T1u} OppR_{Eg} OppR_{T2g}"
stateList = "elastic 1magnon 2magnon"

do for [i = 0:2]{
    
    do for [j = 0:3]{
        
        plot directory.'RIXS_spinwaves_EuO.dat' using 1:(column(3 + i + j*3)) title "Intensity contribution: ".word(stateList, i + 1)." ".word(OppList, j + 1) with lines
    }
}

#set pm3d map interpolate 0, 0

set ylabel "Energy [meV]"
set cblabel "Intensity [a.U.]"
#plot directory . 'RIXS_spinwaves_EuO_w_k.dat' using 1:2:(column(3)) title "S_w_k: elastic" with image
#plot directory . 'RIXS_spinwaves_EuO_w_k.dat' using 1:2:(column(4)) title "S_w_k: 1 magnon" with image
#plot directory . 'RIXS_spinwaves_EuO_w_k.dat' using 1:2:(column(5)) title "S_w_k: 2 magnon" with image

plot directory . 'RIXS_spinwaves_EuO_w_k.dat' using 1:2:(1 - exp(-(column(3) + column(4))*10)) title "RIXS Spectral function" with image

]]

HFM_S_w_k_EuO = [[

directory = "data/"

set style line  1 lt -1 lw 1 lc rgb "#FFFFFF"

set terminal postscript enhanced color
set out '_3_HFM_S_w_k_EuO.ps'

set ylabel "Energy [meV]"
set cblabel "Intensity [a.U.]"

unset xtics

set bmargin screen 0.05

set arrow from 25, graph 0 to 25, graph 1 nohead front linestyle 1
set arrow from 50, graph 0 to 50, graph 1 nohead front linestyle 1
set arrow from 75, graph 0 to 75, graph 1 nohead front linestyle 1

set label "{/Symbol G}" at 0, screen 0.03
set label "X" at 25, screen 0.03
set label "M" at 50, screen 0.03
set label "R" at 75, screen 0.03
set label "{/Symbol G}" at 100, screen 0.03

set yrange [0:12]

plot directory . 'HFM_S_w_k_EuO.dat' using 1:2:(column(3)) title "S_w_k: 1 magnon" with image
plot directory . 'HFM_S_w_k_EuO.dat' using 1:2:(column(4)) title "S_w_k: 2 magnon" with image

]]

XAS_Hz_iso = [[

directory = "data/"

set style line  1 lt -1 lw 1 lc rgb "#0000FF"
set style line  2 lt -1 lw 1 lc rgb "#FF0000"
set style line  3 lt -1 lw 1 lc rgb "#000000"

set output '_2_XAS_Hz_iso.ps'
set terminal postscript enhanced color

set xlabel "Energy [keV]"
set ylabel "Intensity [a.U.]"

stats   sprintf("%sXAS_Hz_iso.dat", directory)  using (($1 + 872.4)/1000):(-column(3))

plot\
        sprintf("%sXAS_Hz_iso.dat", directory)  using (($1 + 872.4)/1000):(-column(3)/STATS_max_y) notitle with lines ls 2,\
                            

]]


file = io.open("RIXSL23M45.gnuplot", "w")

file:write(RIXS_spinwaves_EuO)
--file:write(HFM_S_w_k_EuO)
--file:write(XAS_Hz_iso)

file:close()

os.execute("gnuplot RIXSL23M45.gnuplot")
os.execute("rm RIXSL23M45.gnuplot")

TimeEnd("Plotting RIXS tensor")
TimePrint()
